<?php
/**
 * Password Reset Migration
 * Adds password_resets table for password reset functionality
 */

require_once 'api/config.php';

echo "<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Password Reset Migration</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; background: #f5f5f5; }
        .status { background: white; padding: 20px; margin: 20px 0; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        .success { border-left: 4px solid #10b981; }
        .error { border-left: 4px solid #ef4444; }
        .warning { border-left: 4px solid #f59e0b; }
        h1 { color: #2c3e50; }
        code { background: #f8f9fa; padding: 2px 6px; border-radius: 4px; }
    </style>
</head>
<body>
    <h1>🔐 Password Reset Migration</h1>";

try {
    $pdo = getDBConnection();
    echo "<div class='status success'><strong>✓ Database Connection:</strong> Success</div>";

    // Check if table already exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'password_resets'");
    $tableExists = $stmt->rowCount() > 0;

    if ($tableExists) {
        echo "<div class='status warning'>";
        echo "<strong>ℹ️ Migration Already Completed</strong><br>";
        echo "Password resets table already exists.";
        echo "</div>";
    } else {
        // Create password_resets table (simplified - no 'used' column)
        $sql = "CREATE TABLE password_resets (
            id int(11) NOT NULL AUTO_INCREMENT,
            email varchar(255) NOT NULL,
            token varchar(255) NOT NULL,
            expires_at datetime NOT NULL,
            created_at timestamp DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            UNIQUE KEY email (email),
            KEY token (token),
            KEY expires_at (expires_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        
        $pdo->exec($sql);
        echo "<div class='status success'><strong>✓</strong> Created <code>password_resets</code> table</div>";

        echo "<div class='status success'>";
        echo "<h3>✅ Migration Completed Successfully!</h3>";
        echo "<p>Password reset functionality is now enabled.</p>";
        echo "</div>";
    }

    // Show table structure
    $stmt = $pdo->query("DESCRIBE password_resets");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<div class='status'>";
    echo "<h3>📋 Table Structure</h3>";
    echo "<table style='width: 100%; border-collapse: collapse;'>";
    echo "<tr style='background: #f8f9fa;'>";
    echo "<th style='padding: 8px; border: 1px solid #ddd; text-align: left;'>Field</th>";
    echo "<th style='padding: 8px; border: 1px solid #ddd; text-align: left;'>Type</th>";
    echo "<th style='padding: 8px; border: 1px solid #ddd; text-align: left;'>Key</th>";
    echo "</tr>";
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td style='padding: 8px; border: 1px solid #ddd;'>{$column['Field']}</td>";
        echo "<td style='padding: 8px; border: 1px solid #ddd;'>{$column['Type']}</td>";
        echo "<td style='padding: 8px; border: 1px solid #ddd;'>{$column['Key']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    echo "</div>";

    echo "<div class='status warning'>";
    echo "<h3>⚠️ IMPORTANT - Security</h3>";
    echo "<p><strong>DELETE THIS FILE</strong> after successful migration!</p>";
    echo "</div>";

} catch (Exception $e) {
    echo "<div class='status error'>";
    echo "<h3>❌ Migration Failed</h3>";
    echo "<p><strong>Error:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}

echo "</body></html>";
?>

