<?php
/**
 * Verify Email
 * Verifies the user's email using the token
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Use local config for localhost, production config otherwise
if ($_SERVER['HTTP_HOST'] === 'localhost' || $_SERVER['HTTP_HOST'] === '127.0.0.1' || strpos($_SERVER['HTTP_HOST'], 'localhost:') === 0) {
    require_once 'config_local.php';
} else {
    require_once 'config.php';
}

try {
    $pdo = getDBConnection();
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit;
}

$token = $_GET['token'] ?? '';
if (empty($token)) {
    $input = json_decode(file_get_contents('php://input'), true);
    $token = $input['token'] ?? '';
}

if (empty($token)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Verification token is required']);
    exit;
}

// Find user by verification token
$stmt = $pdo->prepare("SELECT id, email, name, email_verified, verification_token_expires FROM users WHERE verification_token = ?");
$stmt->execute([$token]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid verification token']);
    exit;
}

// Check if already verified
if ($user['email_verified']) {
    echo json_encode([
        'success' => true,
        'message' => 'Your email is already verified!',
        'already_verified' => true,
        'user' => [
            'email' => $user['email'],
            'name' => $user['name'],
            'email_verified' => true
        ]
    ]);
    exit;
}

// Check if token has expired
$currentTime = date('Y-m-d H:i:s');
if ($user['verification_token_expires'] && $currentTime > $user['verification_token_expires']) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Verification link has expired. Please request a new one.',
        'expired' => true
    ]);
    exit;
}

// Verify the email
$stmt = $pdo->prepare("UPDATE users SET email_verified = TRUE, verification_token = NULL, verification_token_expires = NULL WHERE id = ?");
$success = $stmt->execute([$user['id']]);

if ($success) {
    echo json_encode([
        'success' => true,
        'message' => 'Email verified successfully!',
        'user' => [
            'email' => $user['email'],
            'name' => $user['name'],
            'email_verified' => true
        ]
    ]);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to verify email']);
}
?>

