<?php
/**
 * Diagnostic Tool: Check What Database Actually Returns
 * This will help us see exactly what values are in the database
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

try {
    $conn = getDBConnection();
    
    // Get ALL users' notification preferences
    $stmt = $conn->query("SELECT user_email, email_notifications, study_reminders FROM user_settings ORDER BY user_email");
    $allUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "=== ALL USERS IN DATABASE ===\n\n";
    
    foreach ($allUsers as $user) {
        echo "Email: " . $user['user_email'] . "\n";
        echo "  email_notifications: " . var_export($user['email_notifications'], true) . " (type: " . gettype($user['email_notifications']) . ")\n";
        echo "  study_reminders: " . var_export($user['study_reminders'], true) . " (type: " . gettype($user['study_reminders']) . ")\n";
        echo "\n";
    }
    
    // Count by status
    $stmt = $conn->query("SELECT 
        COUNT(*) as total,
        SUM(email_notifications = 1) as email_on,
        SUM(email_notifications = 0) as email_off,
        SUM(study_reminders = 1) as reminder_on,
        SUM(study_reminders = 0) as reminder_off
    FROM user_settings");
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "\n=== STATISTICS ===\n";
    echo "Total Users: " . $stats['total'] . "\n";
    echo "Email Notifications ON: " . $stats['email_on'] . "\n";
    echo "Email Notifications OFF: " . $stats['email_off'] . "\n";
    echo "Study Reminders ON: " . $stats['reminder_on'] . "\n";
    echo "Study Reminders OFF: " . $stats['reminder_off'] . "\n";
    
    echo "\n=== JSON RESPONSE ===\n";
    echo json_encode([
        'total_users' => $stats['total'],
        'email_on' => $stats['email_on'],
        'email_off' => $stats['email_off'],
        'users' => $allUsers
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage();
}
?>

