<?php
require_once 'config.php';

// Enable error logging
error_log("confirm-payment.php called");

try {
    $input = json_decode(file_get_contents('php://input'), true);
    error_log("Input received: " . json_encode($input));
    
    if (!isset($input['paymentIntentId'])) {
        error_log("Payment intent ID missing");
        http_response_code(400);
        echo json_encode(['error' => 'Payment intent ID required']);
        exit;
    }
    
    $paymentIntentId = $input['paymentIntentId'];
    error_log("Payment intent ID: " . $paymentIntentId);
    
    // Retrieve the payment intent
    $paymentIntent = \Stripe\PaymentIntent::retrieve($paymentIntentId);
    error_log("Payment intent retrieved, status: " . $paymentIntent->status);
    
    if ($paymentIntent->status === 'succeeded') {
        error_log("Payment succeeded, processing tokens...");
        
        // Get metadata
        $tokens = (int)$paymentIntent->metadata['tokens'];
        $email = $paymentIntent->metadata['email'];
        error_log("Tokens: $tokens, Email: $email");
        
        // Add tokens to user
        $pdo = getDBConnection();
        $pdo->beginTransaction();
        
        try {
            // Update user tokens
            $stmt = $pdo->prepare("UPDATE users SET tokens = tokens + ? WHERE email = ?");
            $stmt->execute([$tokens, $email]);
            error_log("Tokens updated in database");
            
            // Get updated balance
            $stmt = $pdo->prepare("SELECT tokens FROM users WHERE email = ?");
            $stmt->execute([$email]);
            $user = $stmt->fetch();
            
            $pdo->commit();
            error_log("Transaction committed, new balance: " . $user['tokens']);
            
            $response = [
                'success' => true,
                'message' => 'Payment successful',
                'tokens_added' => $tokens,
                'new_balance' => $user['tokens'],
                'payment_status' => $paymentIntent->status
            ];
            
            error_log("Sending response: " . json_encode($response));
            echo json_encode($response);
            exit;
            
        } catch (Exception $e) {
            error_log("Database error: " . $e->getMessage());
            $pdo->rollBack();
            throw $e;
        }
        
    } else {
        http_response_code(400);
        echo json_encode([
            'error' => 'Payment not completed',
            'status' => $paymentIntent->status
        ]);
    }
    
} catch (\Stripe\Exception\ApiErrorException $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to confirm payment']);
}
?> 