<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'config.php';

try {
    $conn = getDBConnection();
    
    $action = $_GET['action'] ?? $_POST['action'] ?? '';
    
    switch ($action) {
        case 'get':
            handleGetPreferences($conn);
            break;
        case 'save':
            handleSavePreferences($conn);
            break;
        default:
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
}

function handleGetPreferences($conn) {
    $email = $_GET['email'] ?? '';
    
    if (empty($email)) {
        echo json_encode(['success' => false, 'message' => 'Email is required']);
        return;
    }
    
    // Check if user_settings table has notification columns, if not create them
    $result = $conn->query("SHOW COLUMNS FROM user_settings LIKE 'email_notifications'");
    if ($result->rowCount() === 0) {
        // Add notification preference columns
        $conn->query("ALTER TABLE user_settings ADD COLUMN email_notifications BOOLEAN DEFAULT FALSE");
        $conn->query("ALTER TABLE user_settings ADD COLUMN study_reminders BOOLEAN DEFAULT FALSE");
    }
    
    // Get or create user settings
    $stmt = $conn->prepare("SELECT email_notifications, study_reminders FROM user_settings WHERE user_email = ?");
    $stmt->bindParam(1, $email);
    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($result) === 0) {
        // Create default settings - both OFF by default (opt-in)
        $stmt = $conn->prepare("INSERT INTO user_settings (user_email, email_notifications, study_reminders) VALUES (?, 0, 0)");
        $stmt->bindParam(1, $email);
        $stmt->execute();
        
        $preferences = [
            'email_notifications' => 0,
            'study_reminders' => 0
        ];
    } else {
        // Ensure values are integers (0 or 1), not strings or booleans
        $preferences = [
            'email_notifications' => (int)$result[0]['email_notifications'],
            'study_reminders' => (int)$result[0]['study_reminders']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'preferences' => $preferences
    ]);
}

function handleSavePreferences($conn) {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $email = $input['email'] ?? '';
    $emailNotifications = $input['email_notifications'] ?? true;
    $studyReminders = $input['study_reminders'] ?? false;
    
    if (empty($email)) {
        echo json_encode(['success' => false, 'message' => 'Email is required']);
        return;
    }
    
    // Check if user_settings table has notification columns, if not create them
    $result = $conn->query("SHOW COLUMNS FROM user_settings LIKE 'email_notifications'");
    if ($result->rowCount() === 0) {
        // Add notification preference columns
        $conn->query("ALTER TABLE user_settings ADD COLUMN email_notifications BOOLEAN DEFAULT FALSE");
        $conn->query("ALTER TABLE user_settings ADD COLUMN study_reminders BOOLEAN DEFAULT FALSE");
    }
    
    // Update or insert preferences
    $stmt = $conn->prepare("INSERT INTO user_settings (user_email, email_notifications, study_reminders) VALUES (?, ?, ?) 
                           ON DUPLICATE KEY UPDATE email_notifications = VALUES(email_notifications), study_reminders = VALUES(study_reminders)");
    $stmt->bindParam(1, $email);
    $stmt->bindParam(2, $emailNotifications, PDO::PARAM_BOOL);
    $stmt->bindParam(3, $studyReminders, PDO::PARAM_BOOL);
    $stmt->execute();
    
    echo json_encode([
        'success' => true,
        'message' => 'Preferences saved successfully'
    ]);
}
?>
