<?php
// OAuth Configuration for Google and Facebook Login

// Google OAuth Configuration
define('GOOGLE_CLIENT_ID', '187771109045-t9c66ci5uefsn6om573565oq78qgqsqn.apps.googleusercontent.com');
define('GOOGLE_CLIENT_SECRET', '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');
define('GOOGLE_REDIRECT_URI', 'https://app.tofeliq.com/api/oauth.php?action=google-callback');

// Facebook OAuth Configuration
define('FACEBOOK_APP_ID', 'your-facebook-app-id');
define('FACEBOOK_APP_SECRET', 'your-facebook-app-secret');
define('FACEBOOK_REDIRECT_URI', 'https://app.tofeliq.com/api/oauth.php?action=facebook-callback');

// OAuth URLs
define('GOOGLE_AUTH_URL', 'https://accounts.google.com/o/oauth2/v2/auth');
define('GOOGLE_TOKEN_URL', 'https://oauth2.googleapis.com/token');
define('GOOGLE_USERINFO_URL', 'https://www.googleapis.com/oauth2/v2/userinfo');

define('FACEBOOK_AUTH_URL', 'https://www.facebook.com/v12.0/dialog/oauth');
define('FACEBOOK_TOKEN_URL', 'https://graph.facebook.com/v12.0/oauth/access_token');
define('FACEBOOK_USERINFO_URL', 'https://graph.facebook.com/me');

// Helper functions for OAuth
function generateOAuthState() {
    return bin2hex(random_bytes(32));
}

function verifyOAuthState($state, $storedState) {
    return hash_equals($storedState, $state);
}

function getGoogleAuthUrl($state) {
    $params = [
        'client_id' => GOOGLE_CLIENT_ID,
        'redirect_uri' => GOOGLE_REDIRECT_URI,
        'response_type' => 'code',
        'scope' => 'email profile',
        'state' => $state,
        'access_type' => 'offline'
    ];
    
    return GOOGLE_AUTH_URL . '?' . http_build_query($params);
}

function getFacebookAuthUrl($state) {
    $params = [
        'client_id' => FACEBOOK_APP_ID,
        'redirect_uri' => FACEBOOK_REDIRECT_URI,
        'response_type' => 'code',
        'scope' => 'email public_profile',
        'state' => $state
    ];
    
    return FACEBOOK_AUTH_URL . '?' . http_build_query($params);
}

function exchangeGoogleCodeForToken($code) {
    $data = [
        'client_id' => GOOGLE_CLIENT_ID,
        'client_secret' => GOOGLE_CLIENT_SECRET,
        'code' => $code,
        'grant_type' => 'authorization_code',
        'redirect_uri' => GOOGLE_REDIRECT_URI
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, GOOGLE_TOKEN_URL);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

function exchangeFacebookCodeForToken($code) {
    $data = [
        'client_id' => FACEBOOK_APP_ID,
        'client_secret' => FACEBOOK_APP_SECRET,
        'code' => $code,
        'redirect_uri' => FACEBOOK_REDIRECT_URI
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, FACEBOOK_TOKEN_URL . '?' . http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

function getGoogleUserInfo($accessToken) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, GOOGLE_USERINFO_URL . '?access_token=' . $accessToken);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

function getFacebookUserInfo($accessToken) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, FACEBOOK_USERINFO_URL . '?fields=id,name,email&access_token=' . $accessToken);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}
?> 