<?php
/**
 * Give All Users with 0 Tokens → 50 Free Tokens
 * This fixes existing users who registered without getting tokens
 */

header('Content-Type: text/plain');
require_once 'config.php';

try {
    $conn = getDBConnection();
    
    echo "=== GIVE FREE TOKENS TO USERS ===\n\n";
    
    // Check current status
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE tokens = 0");
    $before = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Users with 0 tokens before: " . $before['total'] . "\n";
    
    // Update all users with 0 tokens to have 50 tokens
    echo "\nGiving 50 free tokens to all users with 0 tokens...\n";
    $stmt = $conn->prepare("UPDATE users SET tokens = 50 WHERE tokens = 0");
    $stmt->execute();
    $affectedRows = $stmt->rowCount();
    
    echo "Updated: " . $affectedRows . " users\n";
    
    // Check after status
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE tokens = 0");
    $after = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Users with 0 tokens after: " . $after['total'] . "\n";
    
    // Show some sample records
    echo "\n=== SAMPLE USERS (First 5) ===\n";
    $stmt = $conn->query("SELECT id, email, name, tokens FROM users ORDER BY id DESC LIMIT 5");
    $samples = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($samples as $user) {
        echo "\nEmail: " . $user['email'] . "\n";
        echo "  Name: " . $user['name'] . "\n";
        echo "  Tokens: " . $user['tokens'] . " ";
        echo ($user['tokens'] >= 50 ? "✅" : "❌") . "\n";
    }
    
    echo "\n\n✅ DONE!\n";
    echo "All users now have at least 50 tokens!\n";
    echo "Updated: {$affectedRows} users\n";
    
    // Return JSON for API use
    echo "\n" . json_encode([
        'success' => true,
        'message' => "Gave 50 tokens to {$affectedRows} users",
        'before' => $before['total'],
        'after' => $after['total'],
        'updated' => $affectedRows
    ]);
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage();
    echo json_encode([
        'success' => false,
        'message' => 'Failed: ' . $e->getMessage()
    ]);
}
?>

