<?php
/**
 * FORCE UPDATE: Set ALL Users' Notifications to OFF
 * This is a more aggressive fix that sets EVERYONE to FALSE
 */

header('Content-Type: text/plain');
require_once 'config.php';

try {
    $conn = getDBConnection();
    
    echo "=== FORCE NOTIFICATION UPDATE ===\n\n";
    
    // Check current status
    $stmt = $conn->query("SELECT COUNT(*) as total FROM user_settings WHERE email_notifications = 1");
    $before = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Users with email_notifications = ON before: " . $before['total'] . "\n";
    
    // Force update ALL users to have notifications OFF
    echo "\nUpdating all users...\n";
    $stmt = $conn->exec("UPDATE user_settings SET email_notifications = 0, study_reminders = 0");
    echo "Affected rows: " . $stmt . "\n";
    
    // Check after status
    $stmt = $conn->query("SELECT COUNT(*) as total FROM user_settings WHERE email_notifications = 1");
    $after = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Users with email_notifications = ON after: " . $after['total'] . "\n";
    
    // Show some sample records
    echo "\n=== SAMPLE RECORDS (First 5 users) ===\n";
    $stmt = $conn->query("SELECT user_email, email_notifications, study_reminders FROM user_settings LIMIT 5");
    $samples = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($samples as $user) {
        echo "\nEmail: " . $user['user_email'] . "\n";
        echo "  email_notifications: " . $user['email_notifications'] . " (should be 0)\n";
        echo "  study_reminders: " . $user['study_reminders'] . " (should be 0)\n";
    }
    
    echo "\n\n✅ DONE!\n";
    echo "All users now have:\n";
    echo "  - email_notifications = 0 (OFF)\n";
    echo "  - study_reminders = 0 (OFF)\n";
    echo "\nNow logout and login to test!\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage();
}
?>

