-- Fix Database Default Value for Tokens Column
-- This changes the default from 0 to 50 for the tokens column

-- Change the default value for existing table
ALTER TABLE users MODIFY COLUMN tokens int(11) DEFAULT 50;

-- Give 50 tokens to all existing users who have 0 tokens
UPDATE users SET tokens = 50 WHERE tokens = 0;

-- Verify the change
SELECT COUNT(*) as users_with_zero_tokens FROM users WHERE tokens = 0;
-- Should return 0

-- Show sample users
SELECT id, email, name, tokens FROM users ORDER BY id DESC LIMIT 5;

