<?php
/**
 * Migration Script: Fix Notification Preference Defaults
 * 
 * This script updates existing users' notification preferences
 * to set email_notifications to FALSE by default (opt-in approach)
 * 
 * Run this ONCE after deploying the updated preferences.php
 */

header('Content-Type: application/json');
require_once 'config.php';

try {
    $conn = getDBConnection();
    
    // Count users before update
    $stmt = $conn->query("SELECT COUNT(*) as total FROM user_settings WHERE email_notifications = TRUE");
    $before = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "Found {$before['total']} users with email_notifications = TRUE\n";
    
    // Update all users to have email_notifications = FALSE
    // This creates an opt-in system (users must explicitly enable notifications)
    $stmt = $conn->query("UPDATE user_settings SET email_notifications = FALSE WHERE email_notifications = TRUE");
    $affectedRows = $stmt->rowCount();
    
    echo "Updated {$affectedRows} user records\n";
    
    // Verify update
    $stmt = $conn->query("SELECT COUNT(*) as total FROM user_settings WHERE email_notifications = TRUE");
    $after = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "\nVerification:\n";
    echo "- Before: {$before['total']} users with notifications ON\n";
    echo "- After: {$after['total']} users with notifications ON\n";
    echo "- Changed: {$affectedRows} records\n";
    
    if ($after['total'] == 0) {
        echo "\n✅ SUCCESS: All users now have email_notifications = FALSE (opt-in)\n";
    }
    
    echo json_encode([
        'success' => true,
        'message' => "Updated {$affectedRows} user notification preferences",
        'before' => $before['total'],
        'after' => $after['total']
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Migration failed: ' . $e->getMessage()
    ]);
}
?>

