-- Affiliate Program Database Tables

-- Affiliate data table
CREATE TABLE IF NOT EXISTS affiliate_data (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    affiliate_code VARCHAR(20) UNIQUE NOT NULL,
    total_earnings DECIMAL(10,2) DEFAULT 0.00,
    this_month_earnings DECIMAL(10,2) DEFAULT 0.00,
    last_month_earnings DECIMAL(10,2) DEFAULT 0.00,
    total_referrals INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_affiliate_code (affiliate_code),
    INDEX idx_user_id (user_id)
);

-- Referrals table
CREATE TABLE IF NOT EXISTS referrals (
    id INT AUTO_INCREMENT PRIMARY KEY,
    affiliate_id INT NOT NULL,
    referred_user_id INT NOT NULL,
    referred_email VARCHAR(255) NOT NULL,
    referred_name VARCHAR(255) NOT NULL,
    status ENUM('active', 'inactive', 'pending') DEFAULT 'active',
    earnings DECIMAL(10,2) DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (affiliate_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (referred_user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_affiliate_id (affiliate_id),
    INDEX idx_referred_user_id (referred_user_id),
    INDEX idx_status (status)
);

-- Insert sample affiliate data for existing users (optional)
-- This will create affiliate codes for users who don't have them yet
INSERT IGNORE INTO affiliate_data (user_id, affiliate_code, total_earnings, this_month_earnings, last_month_earnings, total_referrals)
SELECT 
    u.id,
    CONCAT('AFF', LPAD(u.id, 6, '0')),
    0.00,
    0.00,
    0.00,
    0
FROM users u
WHERE u.id NOT IN (SELECT user_id FROM affiliate_data);
