<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config.php';

try {
    $pdo = getDBConnection();
    $input = json_decode(file_get_contents('php://input'), true);
    $userId = $input['userId'] ?? null;
    $email = $input['email'] ?? null;
    
    if (!$userId || !$email) {
        throw new Exception('User ID and email are required');
    }
    
    // Check if user already has an affiliate code
    $stmt = $pdo->prepare("SELECT affiliate_code FROM affiliate_data WHERE user_id = ?");
    $stmt->execute([$userId]);
    $existing = $stmt->fetch();
    
    if ($existing) {
        $affiliateCode = $existing['affiliate_code'];
    } else {
        // Generate new affiliate code
        $affiliateCode = generateAffiliateCode();
        
        // Insert new affiliate data
        $stmt = $pdo->prepare("
            INSERT INTO affiliate_data (user_id, affiliate_code, total_earnings, this_month_earnings, last_month_earnings, total_referrals)
            VALUES (?, ?, 0, 0, 0, 0)
        ");
        $stmt->execute([$userId, $affiliateCode]);
    }
    
    echo json_encode([
        'success' => true,
        'affiliateCode' => $affiliateCode
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

function generateAffiliateCode() {
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $code = '';
    for ($i = 0; $i < 8; $i++) {
        $code .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $code;
}
?>
