<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config.php';

try {
    $pdo = getDBConnection();
    $input = json_decode(file_get_contents('php://input'), true);
    $userId = $input['userId'] ?? null;
    
    if (!$userId) {
        throw new Exception('User ID is required');
    }
    
    // Get affiliate data from database
    $stmt = $pdo->prepare("
        SELECT 
            affiliate_code,
            total_earnings,
            this_month_earnings,
            last_month_earnings,
            total_referrals
        FROM affiliate_data 
        WHERE user_id = ?
    ");
    $stmt->execute([$userId]);
    $affiliateData = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$affiliateData) {
        // Generate new affiliate code if user doesn't have one
        $affiliateCode = generateAffiliateCode();
        
        $stmt = $pdo->prepare("
            INSERT INTO affiliate_data (user_id, affiliate_code, total_earnings, this_month_earnings, last_month_earnings, total_referrals)
            VALUES (?, ?, 0, 0, 0, 0)
        ");
        $stmt->execute([$userId, $affiliateCode]);
        
        $affiliateData = [
            'affiliateCode' => $affiliateCode,
            'totalEarnings' => 0,
            'thisMonthEarnings' => 0,
            'lastMonthEarnings' => 0,
            'totalReferrals' => 0,
            'referrals' => []
        ];
    } else {
        // Get referrals list
        $stmt = $pdo->prepare("
            SELECT 
                r.id,
                r.referred_email,
                r.referred_name,
                r.status,
                r.created_at,
                r.earnings
            FROM referrals r
            WHERE r.affiliate_id = ?
            ORDER BY r.created_at DESC
        ");
        $stmt->execute([$userId]);
        $referrals = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $affiliateData = [
            'affiliateCode' => $affiliateData['affiliate_code'],
            'totalEarnings' => (float)$affiliateData['total_earnings'],
            'thisMonthEarnings' => (float)$affiliateData['this_month_earnings'],
            'lastMonthEarnings' => (float)$affiliateData['last_month_earnings'],
            'totalReferrals' => (int)$affiliateData['total_referrals'],
            'referrals' => $referrals
        ];
    }
    
    echo json_encode([
        'success' => true,
        'data' => $affiliateData
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

function generateAffiliateCode() {
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $code = '';
    for ($i = 0; $i < 8; $i++) {
        $code .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $code;
}
?>
