# 🔵 Facebook OAuth Setup Guide

Complete step-by-step guide to enable "Continue with Facebook" login.

---

## ✅ What's Already Done

The code is **already implemented**! You just need to configure it:
- ✅ Backend OAuth handlers (api/oauth.php)
- ✅ Frontend Facebook button (src/components/Auth.jsx)
- ✅ Database integration
- ✅ Auto-email verification for Facebook users
- ✅ Beautiful UI

You just need to:
1. Create Facebook App
2. Get App ID & Secret
3. Configure redirect URI
4. Update config file

---

## 📋 Step-by-Step Setup

### **STEP 1: Create Facebook App**

1. **Go to Facebook Developers Console:**
   ```
   https://developers.facebook.com/
   ```

2. **Login with your Facebook account**

3. **Click "My Apps" (top right)**

4. **Click "Create App"**

5. **Select use case:**
   - Choose: **"Allow people to log in with their Facebook account"**
   - Click **"Next"**

6. **Select app type:**
   - Choose: **"Consumer"**
   - Click **"Next"**

7. **Add app details:**
   ```
   App Name: TOEFL Analyzer
   App Contact Email: your-email@example.com
   ```
   - Click **"Create App"**

8. **You'll be redirected to the app dashboard**

---

### **STEP 2: Configure Facebook Login**

1. **In the app dashboard, find "Facebook Login"**
   - Click **"Set Up"** on the Facebook Login card

2. **Select Platform:**
   - Choose **"Web"**

3. **Enter Site URL:**
   ```
   https://app.tofeliq.com
   ```
   - Click **"Save"**
   - Click **"Continue"**

4. **Skip the quickstart** (we've already implemented the code)
   - Click **"Settings"** in left sidebar under "Facebook Login"

---

### **STEP 3: Configure OAuth Redirect URIs**

1. **In "Facebook Login" → "Settings"**

2. **Find "Valid OAuth Redirect URIs"**

3. **Add this EXACT URL:**
   ```
   https://app.tofeliq.com/api/oauth.php?action=facebook-callback
   ```

4. **Click "Save Changes"** (bottom right)

⚠️ **IMPORTANT:** The URL must be EXACTLY as shown, including the query parameter!

---

### **STEP 4: Get App Credentials**

1. **Go to "Settings" → "Basic" (left sidebar)**

2. **Copy these values:**
   ```
   App ID: [Your App ID - e.g., 123456789012345]
   App Secret: [Click "Show" to reveal, then copy]
   ```

3. **Keep these safe!** You'll need them in the next step.

---

### **STEP 5: Make App Live**

1. **At the top of the page, you'll see a toggle switch**
   - Currently shows: **"In Development"**

2. **Click the toggle to switch to "Live"**
   - Confirm the action

3. **Your app is now live!**

---

### **STEP 6: Update Your Config File**

**Send me your Facebook credentials:**
```
App ID: [paste here]
App Secret: [paste here]
```

And I'll update the config file for you!

**OR do it manually:**

Edit `api/oauth-config.php`:

```php
// Facebook OAuth Configuration
define('FACEBOOK_APP_ID', 'YOUR_APP_ID_HERE');
define('FACEBOOK_APP_SECRET', 'YOUR_APP_SECRET_HERE');
define('FACEBOOK_REDIRECT_URI', 'https://app.tofeliq.com/api/oauth.php?action=facebook-callback');
```

---

### **STEP 7: Upload & Test**

1. **Upload updated config file to server**

2. **Clear browser cache** (Ctrl+Shift+Delete)

3. **Go to:** https://app.tofeliq.com/

4. **Click "Continue with Facebook"**

5. **You should see Facebook login popup!**

6. **After login, you're automatically logged into TOEFL Analyzer!**

---

## 🎯 Testing Checklist

### Test Facebook Login:
- [ ] Click "Continue with Facebook"
- [ ] Facebook login popup appears
- [ ] Select your Facebook account
- [ ] Approve permissions
- [ ] Redirected back to app
- [ ] Logged in automatically
- [ ] Email shows as verified (green badge)
- [ ] User created in database

### Test Existing User:
- [ ] Login with Facebook (first time)
- [ ] Logout
- [ ] Login with Facebook again
- [ ] Should login immediately (no new user created)

### Test Email Linking:
- [ ] Register regular account with email
- [ ] Logout
- [ ] Login with Facebook (same email)
- [ ] Accounts should be linked
- [ ] Email becomes verified

---

## 🔒 Security Features

✅ State parameter validation (CSRF protection)  
✅ Secure token exchange  
✅ OAuth 2.0 standard  
✅ Auto-email verification  
✅ Encrypted password storage (Facebook users don't need password)  
✅ SQL injection protection  

---

## 📊 Facebook vs Google Login

| Feature | Google | Facebook |
|---------|--------|----------|
| Auto-verified | ✅ Yes | ✅ Yes |
| Email required | ✅ Yes | ✅ Yes |
| Setup complexity | Easy | Easy |
| User data | Email, Name | Email, Name |
| Password needed | ❌ No | ❌ No |

---

## 🐛 Troubleshooting

### Problem: "URL Not Allowed by Application"

**Cause:** Redirect URI not configured correctly in Facebook App

**Fix:**
1. Go to Facebook Developers Console
2. Settings → Basic → Add Platform → Website
3. Add: `https://app.tofeliq.com`
4. Go to Facebook Login → Settings
5. Add to "Valid OAuth Redirect URIs":
   ```
   https://app.tofeliq.com/api/oauth.php?action=facebook-callback
   ```

---

### Problem: "Invalid OAuth Callback"

**Cause:** State parameter mismatch or missing

**Fix:**
1. Clear browser cookies
2. Try again
3. Check server session storage is working

---

### Problem: "App Not Setup"

**Cause:** App is still in development mode

**Fix:**
1. Go to Facebook Developers Console
2. Toggle app to "Live" mode
3. Make sure privacy policy URL is set (if required)

---

### Problem: Email Not Returned

**Cause:** Email permission not requested

**Fix:**
Already configured! The code requests `email` permission.
If still not working:
1. Check user approved email permission
2. Some Facebook accounts don't have email (rare)

---

## 📧 Required Permissions

The app requests these Facebook permissions:
- ✅ `email` - User's email address
- ✅ `public_profile` - User's name and profile picture

These are basic permissions that don't require app review.

---

## 🎨 UI Preview

**Login Page:**
```
┌─────────────────────────────────────┐
│         Welcome Back                │
│    Sign in to your account          │
│                                     │
│  Email: [________________]          │
│  Password: [________________]       │
│                                     │
│         [ Sign In ]                 │
│                                     │
│            or                       │
│                                     │
│  [ 🔵 Continue with Facebook ]     │
│  [ 🔴 Continue with Google    ]     │
└─────────────────────────────────────┘
```

---

## ✅ Summary

Once configured, Facebook login will:
1. ✅ Show "Continue with Facebook" button
2. ✅ Open Facebook login popup
3. ✅ Auto-verify user's email
4. ✅ Create account or login existing user
5. ✅ Show green "Email Verified" badge
6. ✅ Work seamlessly with rest of app

---

## 📞 Next Steps

**After completing the steps above:**

1. Send me your Facebook credentials:
   - App ID
   - App Secret

2. I'll update the config file and create a new build

3. Upload to server

4. Test!

---

**Let me know your App ID and Secret, and I'll configure it for you!** 🚀

